<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\User;

class HomeController extends Controller
{
    public function index()
    {
        // Assume first user is admin
        $admin = User::first();

        // Default behavior if no admin setting found
        if (!$admin) {
            return view('home');
        }

        $mode = $admin->homepage_mode ?? 'default';

        if ($mode === 'not_found') {
            abort(404);
        }

        if ($mode === 'redirect' && !empty($admin->homepage_redirect_url)) {
            // Redirect without logging implies using 'away' directly or simple redirect
            return redirect()->away($admin->homepage_redirect_url);
        }

        // Default mode
        return view('home');
    }
}
