<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LoginNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public $agent;
    public $ip;
    public $time;

    public function __construct($agent, $ip, $time)
    {
        $this->agent = $agent;
        $this->ip = $ip;
        $this->time = $time;
    }

    public function via(object $notifiable): array
    {
        return ['database'];
    }

    public function toArray(object $notifiable): array
    {
        return [
            'title' => 'Login Terdeteksi',
            'message' => "Login baru dari {$this->agent} ({$this->ip}).",
            'icon' => 'fa-right-to-bracket',
            'color' => 'text-indigo-600 bg-indigo-50',
            'link' => null // No specific link
        ];
    }
}
