@extends('layouts.dashboard')

@section('title', 'Dashboard - Selinku')

@push('styles')
<style>
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    
    /* Slide down animation for toggle fields */
    @keyframes slideDown {
        from {
            opacity: 0;
            max-height: 0;
            transform: translateY(-10px);
        }
        to {
            opacity: 1;
            max-height: 500px;
            transform: translateY(0);
        }
    }
    
    .animate-slideDown {
        animation: slideDown 0.3s ease-out forwards;
    }
    
    /* Fix preview card width on mobile */
    @media (max-width: 1023px) {
        #previewImage {
            max-width: 100%;
            height: auto;
            object-fit: cover;
        }
        
        /* Ensure preview card doesn't overflow */
        .lg\:sticky {
            max-width: 100%;
            overflow: hidden;
        }
    }
</style>
@endpush

@section('content')
<div class="max-w-7xl mx-auto space-y-6">
    
    <!-- Header Text -->
    <div>
        <h2 class="text-2xl font-bold text-slate-900">Buat Shortlink Baru</h2>
        <p class="text-slate-500 mt-1">Masukan URL/Link panjang Anda di kolom bawah, tambahkan juga nama dan kustom jika diperlukan.</p>
    </div>

    <!-- 2 Column Layout: Form (Left) + Result (Right) -->
    <div class="grid lg:grid-cols-2 gap-6 items-start">
        
        <!-- LEFT COLUMN: Form -->
        <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6 lg:p-8">
            <form action="#" method="POST" id="shortenForm">
                @csrf
                <div class="grid gap-6">
                    
                    <!-- Input URL Asli -->
                    <div>
                        <label for="longUrl" class="block text-sm font-medium text-slate-700 mb-2">
                            URL Asli (Tujuan) <span class="text-red-500">*</span>
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fa-solid fa-link text-slate-400"></i>
                            </div>
                            <input type="url" id="longUrl" name="url" required 
                                class="block w-full pl-10 pr-3 py-3 border border-slate-300 rounded-lg leading-5 bg-white placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm transition-shadow" 
                                placeholder="https://contoh-website-anda.com/halaman-yang-sangat-panjang">
                        </div>
                    </div>

                    <!-- Optional Fields Group -->
                    <div class="flex flex-col gap-2 pt-2 border-t border-slate-200">
                        <p class="text-xs text-slate-500 mb-1 lg:hidden">
                            <i class="fa-solid fa-sliders"></i> Opsi Tambahan:
                        </p>

                        <!-- Toggle Title -->
                        <button type="button" id="toggleTitleBtn" 
                            class="w-full px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-lg text-sm font-medium text-slate-700 hover:bg-slate-100 transition-colors flex items-center justify-between lg:hidden">
                            <span class="flex items-center gap-2">
                                <i class="fa-solid fa-heading text-slate-400"></i>
                                Tambah Nama Link (Opsional)
                            </span>
                            <i class="fa-solid fa-chevron-down text-slate-400 transition-transform" id="titleChevron"></i>
                        </button>
                        
                        <!-- Input Title -->
                        <div id="titleField" class="hidden lg:block">
                            <label for="linkTitle" class="block text-sm font-medium text-slate-700 mb-2 lg:mt-2">
                                Nama Link (Title) <span class="text-slate-400 text-xs">(Opsional)</span>
                            </label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fa-solid fa-heading text-slate-400"></i>
                                </div>
                                <input type="text" id="linkTitle" name="title"
                                    class="block w-full pl-10 pr-3 py-3 border border-slate-300 rounded-lg leading-5 bg-white placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm transition-shadow" 
                                    placeholder="Kosongkan untuk auto-fetch">
                            </div>
                        </div>

                        <!-- Toggle Alias -->
                        <button type="button" id="toggleAliasBtn"
                            class="w-full px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-lg text-sm font-medium text-slate-700 hover:bg-slate-100 transition-colors flex items-center justify-between lg:hidden">
                            <span class="flex items-center gap-2">
                                <i class="fa-solid fa-tag text-slate-400"></i>
                                Tambah Custom Alias (Opsional)
                            </span>
                            <i class="fa-solid fa-chevron-down text-slate-400 transition-transform" id="aliasChevron"></i>
                        </button>

                        <!-- Input Alias -->
                        <div id="aliasField" class="hidden lg:block">
                            <label for="customAlias" class="block text-sm font-medium text-slate-700 mb-2 lg:mt-2">
                                Custom Alias <span class="text-slate-400 text-xs">(Opsional)</span>
                            </label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="text-slate-400 text-sm">/</span>
                                </div>
                                <input type="text" id="customAlias" name="alias"
                                    class="block w-full pl-6 pr-3 py-3 border border-slate-300 rounded-lg leading-5 bg-white placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm" 
                                    placeholder="promo-januari">
                            </div>
                            <p class="mt-1 text-xs text-slate-500 lg:mb-2">Biarkan kosong untuk alias acak.</p>
                        </div>

                        <!-- Manual Metadata Section Info -->
                        <p class="text-xs text-slate-500 mt-2 mb-1 pt-2 border-t border-slate-100">
                            <i class="fa-solid fa-info-circle"></i> Input Manual (Jika auto-fetch gagal):
                        </p>

                        <!-- Toggle Description -->
                        <button type="button" id="toggleDescBtn"
                            class="w-full px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-lg text-sm font-medium text-slate-700 hover:bg-slate-100 transition-colors flex items-center justify-between">
                            <span class="flex items-center gap-2">
                                <i class="fa-solid fa-align-left text-slate-400"></i>
                                Tambah Deskripsi Manual (Opsional)
                            </span>
                            <i class="fa-solid fa-chevron-down text-slate-400 transition-transform" id="descChevron"></i>
                        </button>

                        <!-- Input Description -->
                        <div id="descField" class="hidden">
                            <div class="relative mt-2">
                                <textarea id="linkDescription" name="description" rows="3"
                                    class="block w-full px-3 py-3 border border-slate-300 rounded-lg leading-5 bg-white placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm transition-shadow resize-none" 
                                    placeholder="Deskripsi singkat..."></textarea>
                            </div>
                        </div>

                        <!-- Toggle Image -->
                        <button type="button" id="toggleImageBtn"
                            class="w-full px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-lg text-sm font-medium text-slate-700 hover:bg-slate-100 transition-colors flex items-center justify-between">
                            <span class="flex items-center gap-2">
                                <i class="fa-solid fa-image text-slate-400"></i>
                                Tambah URL Gambar Manual (Opsional)
                            </span>
                            <i class="fa-solid fa-chevron-down text-slate-400 transition-transform" id="imageChevron"></i>
                        </button>

                        <!-- Input Image -->
                        <div id="imageField" class="hidden">
                            <div class="relative mt-2">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="fa-solid fa-image text-slate-400"></i>
                                </div>
                                <input type="url" id="linkImage" name="og_image"
                                    class="block w-full pl-10 pr-3 py-3 border border-slate-300 rounded-lg leading-5 bg-white placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm transition-shadow" 
                                    placeholder="https://example.com/image.jpg">
                            </div>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="pt-2">
                        <button type="submit" id="submitBtn" class="w-full px-6 py-3 bg-emerald-600 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 transition-all flex items-center justify-center gap-2">
                            <i class="fa-solid fa-wand-magic-sparkles"></i>
                            Proses
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- RIGHT COLUMN: Placeholder / Result & Preview -->
        <div class="lg:sticky lg:top-6">
            <!-- Placeholder (shown when no result, desktop only) -->
            <div id="resultPlaceholder" class="hidden lg:block bg-slate-50 rounded-xl border-2 border-dashed border-slate-200 p-8 text-center">
                <div class="flex flex-col items-center justify-center space-y-4">
                    <div class="w-16 h-16 bg-slate-100 rounded-full flex items-center justify-center">
                        <i class="fa-solid fa-eye text-slate-300 text-2xl"></i>
                    </div>
                    <div>
                        <h3 class="text-sm font-semibold text-slate-600 mb-1">Preview Link</h3>
                        <p class="text-xs text-slate-400">Preview akan muncul setelah link berhasil dibuat</p>
                    </div>
                    <div class="flex items-center gap-2 text-xs text-slate-400">
                        <i class="fa-solid fa-arrow-left"></i>
                        <span>Isi form di sebelah kiri</span>
                    </div>
                </div>
            </div>

            <!-- Result Card (hidden by default) -->
            <div id="resultCard" class="hidden">
                <!-- Success Message & Actions -->
                <div class="bg-emerald-50 rounded-lg p-3 sm:p-4 border border-emerald-200 mb-3 sm:mb-4">
                <div class="flex items-center gap-2 sm:gap-3 mb-2 sm:mb-3">
                    <div class="bg-emerald-100 p-1.5 sm:p-2 rounded-full text-emerald-600 flex-shrink-0">
                        <i class="fa-solid fa-check text-sm"></i>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-[10px] sm:text-xs text-emerald-700 font-semibold uppercase tracking-wide">Shortlink Berhasil Dibuat!</p>
                        <a href="#" id="generatedLink" target="_blank" class="text-sm sm:text-lg font-bold text-slate-800 hover:text-emerald-600 truncate block break-all">s.id/promo-januari</a>
                    </div>
                </div>
                <div>
                    <button onclick="copyGeneratedLink()" class="w-full px-3 sm:px-4 py-2 bg-white border border-slate-300 rounded-md text-xs sm:text-sm font-medium text-slate-700 hover:bg-slate-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 transition-colors">
                        <i class="fa-regular fa-copy mr-1"></i> Copy Link
                    </button>
                </div>
            </div>

            <!-- Social Media Preview -->
            <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-4 sm:p-6">
                <h3 class="text-sm font-semibold text-slate-700 mb-3 flex items-center gap-2">
                    <i class="fa-solid fa-eye text-emerald-600"></i>
                    Preview di Sosial Media
                </h3>
                
                <!-- Preview Card (Facebook/WhatsApp Style) -->
                <div class="bg-white border border-slate-200 rounded-lg overflow-hidden shadow-sm hover:shadow-md transition-shadow max-w-sm mx-auto lg:max-w-none">
                    <!-- Image Preview -->
                    <div id="previewImageContainer" class="hidden">
                        <img id="previewImage" src="" alt="Preview" class="w-full h-36 sm:h-48 object-cover bg-slate-100">
                    </div>
                    
                    <!-- No Image Placeholder (Elegant Gradient) -->
                    <div id="previewNoImage" class="w-full h-24 sm:h-32 bg-gradient-to-tr from-slate-100 via-emerald-50 to-slate-100 flex items-center justify-center border-b border-slate-100">
                        <div class="bg-white/50 p-3 rounded-full shadow-sm backdrop-blur-sm">
                            <i class="fa-solid fa-link text-xl sm:text-2xl text-emerald-300"></i>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-3 sm:p-4 bg-[#f0f2f5] sm:bg-white border-t border-slate-100">
                        <div class="text-[10px] text-slate-500 uppercase mb-1 flex items-center gap-1 break-words">
                            <span id="previewDomain" class="truncate">example.com</span>
                        </div>
                        <h4 id="previewTitle" class="font-bold text-slate-900 text-sm sm:text-base mb-1 line-clamp-2 break-words leading-tight">
                            Judul Link Anda
                        </h4>
                        <p id="previewDescription" class="text-xs sm:text-sm text-slate-600 line-clamp-2 break-words leading-snug">
                            Deskripsi akan muncul di sini jika tersedia
                        </p>
                    </div>
                </div>

                <div class="mt-3 text-[10px] text-slate-400 space-y-1 leading-tight">
                    <p>1. Preview tampilan shortlink Anda. Di beberapa sosial media mungkin hasil akhirnya berbeda. Gunakan input kustom manual jika auto fetch tidak berfungsi.</p>
                    <p>2. Kami melakukan optimasi ketat untuk akurasi data, dan mungkin beberapa situs memerlukan akses bot yang lebih, sehingga auto fetch untuk preview mungkin tidak berfungsi ke situs tersebut.</p>
                    <p>3. Bagikan link Anda ke sosial media (jika perlu) untuk memastikan hasil aslinya.</p>
                </div>
            </div>
        </div>

    </div>

</div>

@push('scripts')
<script>
    // Toggle Optional Fields (Mobile Only)
    document.getElementById('toggleTitleBtn')?.addEventListener('click', function() {
        const field = document.getElementById('titleField');
        const chevron = document.getElementById('titleChevron');
        
        if (field.classList.contains('hidden')) {
            field.classList.remove('hidden');
            field.classList.add('animate-slideDown');
            chevron.style.transform = 'rotate(180deg)';
        } else {
            field.classList.add('hidden');
            field.classList.remove('animate-slideDown');
            chevron.style.transform = 'rotate(0deg)';
        }
    });

    document.getElementById('toggleAliasBtn')?.addEventListener('click', function() {
        const field = document.getElementById('aliasField');
        const chevron = document.getElementById('aliasChevron');
        
        if (field.classList.contains('hidden')) {
            field.classList.remove('hidden');
            field.classList.add('animate-slideDown');
            chevron.style.transform = 'rotate(180deg)';
        } else {
            field.classList.add('hidden');
            field.classList.remove('animate-slideDown');
            chevron.style.transform = 'rotate(0deg)';
        }
    });

    // Toggle Description Field
    document.getElementById('toggleDescBtn')?.addEventListener('click', function() {
        const field = document.getElementById('descField');
        const chevron = document.getElementById('descChevron');
        
        if (field.classList.contains('hidden')) {
            field.classList.remove('hidden');
            field.classList.add('animate-slideDown');
            chevron.style.transform = 'rotate(180deg)';
        } else {
            field.classList.add('hidden');
            field.classList.remove('animate-slideDown');
            chevron.style.transform = 'rotate(0deg)';
        }
    });

    // Toggle Image Field
    document.getElementById('toggleImageBtn')?.addEventListener('click', function() {
        const field = document.getElementById('imageField');
        const chevron = document.getElementById('imageChevron');
        
        if (field.classList.contains('hidden')) {
            field.classList.remove('hidden');
            field.classList.add('animate-slideDown');
            chevron.style.transform = 'rotate(180deg)';
        } else {
            field.classList.add('hidden');
            field.classList.remove('animate-slideDown');
            chevron.style.transform = 'rotate(0deg)';
        }
    });

    // Form Handling Logic
    document.getElementById('shortenForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const btn = document.getElementById('submitBtn');
        const originalText = btn.innerHTML;
        const linkTitle = document.getElementById('linkTitle').value;
        const longUrl = document.getElementById('longUrl').value;
        const customAlias = document.getElementById('customAlias').value;
        const linkDescription = document.getElementById('linkDescription').value;
        const linkImage = document.getElementById('linkImage').value;
        
        // Loading State
        btn.disabled = true;
        btn.innerHTML = '<i class="fa-solid fa-circle-notch fa-spin"></i> Memproses...';

        // AJAX Call to create shortlink
        fetch('{{ route('shortlinks.store') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json'
            },
            body: JSON.stringify({
                title: linkTitle,
                url: longUrl,
                alias: customAlias,
                description: linkDescription,
                og_image: linkImage
            })
        })
        .then(response => response.json())
        .then(data => {
            // Reset Button
            btn.disabled = false;
            btn.innerHTML = originalText;

            if (data.success) {
                // Hide placeholder, show result card
                const placeholder = document.getElementById('resultPlaceholder');
                const resultCard = document.getElementById('resultCard');
                
                placeholder.style.display = 'none';
                resultCard.classList.remove('hidden');
                resultCard.classList.add('fade-in');
                
                document.getElementById('generatedLink').textContent = data.data.short_url;
                document.getElementById('generatedLink').href = data.data.short_url;
                
                // Populate Preview Card
                populatePreview(data.data);
                
                // Reset form
                document.getElementById('linkTitle').value = '';
                document.getElementById('longUrl').value = '';
                document.getElementById('customAlias').value = '';
                document.getElementById('linkDescription').value = '';
                document.getElementById('linkImage').value = '';
                
                showToast(data.message);
            } else {
                showToast(data.message || 'Gagal membuat shortlink', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            btn.disabled = false;
            btn.innerHTML = originalText;
            showToast('Terjadi kesalahan. Silakan coba lagi.', 'error');
        });
    });

    // Populate Preview Card
    function populatePreview(linkData) {
        const { title, description, og_image, original_url } = linkData;
        
        // Extract domain from URL
        const domain = extractDomain(original_url);
        
        // Set domain
        document.getElementById('previewDomain').textContent = domain;
        
        // Set title
        document.getElementById('previewTitle').textContent = title || 'Shortlink';
        
        // Set description
        const descElement = document.getElementById('previewDescription');
        if (description) {
            descElement.textContent = description;
            descElement.classList.remove('hidden');
            descElement.classList.remove('text-slate-400', 'italic');
        } else {
            descElement.textContent = 'Tidak ada deskripsi tersedia';
            descElement.classList.add('text-slate-400', 'italic');
        }
        
        // Set image
        const imageContainer = document.getElementById('previewImageContainer');
        const noImagePlaceholder = document.getElementById('previewNoImage');
        const imageElement = document.getElementById('previewImage');
        
        if (og_image) {
            imageElement.src = og_image;
            imageContainer.classList.remove('hidden');
            noImagePlaceholder.classList.add('hidden');
            
            // Handle broken image links
            imageElement.onerror = function() {
                this.onerror = null; // Prevent infinite loop
                imageContainer.classList.add('hidden');
                noImagePlaceholder.classList.remove('hidden');
            };
        } else {
            imageContainer.classList.add('hidden');
            noImagePlaceholder.classList.remove('hidden');
        }
    }

    // Extract domain from URL
    function extractDomain(url) {
        try {
            const urlObj = new URL(url);
            return urlObj.hostname.replace('www.', '');
        } catch (e) {
            return 'unknown';
        }
    }

    // Copy Generated Link (Using link from result card)
    function copyGeneratedLink() {
        const linkText = document.getElementById('generatedLink').href;
        copyLink(linkText);
    }
</script>
@endpush
@endsection
