@extends('layouts.dashboard')

@section('content')
<div class="max-w-4xl mx-auto space-y-6">
    <!-- Header -->
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-slate-800">Pengaturan Profil</h2>
        <p class="text-slate-500">Kelola informasi akun dan keamanan Anda di sini.</p>
    </div>

    <!-- Alert Messages -->
    @if(session('success'))
    <div class="bg-emerald-50 text-emerald-600 px-4 py-3 rounded-lg flex items-center gap-3 border border-emerald-100">
        <i class="fa-solid fa-circle-check"></i>
        {{ session('success') }}
    </div>
    @endif

    @if($errors->any())
    <div class="bg-red-50 text-red-600 px-4 py-3 rounded-lg border border-red-100 mb-4">
        <ul class="list-disc list-inside text-sm">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="grid grid-cols-1 gap-6">
        
        <!-- Profile Information -->
        <div class="bg-white p-6 rounded-xl border border-slate-200 shadow-sm">
            <div class="flex items-center gap-3 mb-6 pb-4 border-b border-slate-100">
                <div class="w-10 h-10 rounded-full bg-emerald-100 text-emerald-600 flex items-center justify-center">
                    <i class="fa-regular fa-id-card text-lg"></i>
                </div>
                <div>
                    <h3 class="font-bold text-slate-800">Informasi Dasar</h3>
                    <p class="text-xs text-slate-500">Perbarui nama dan alamat email akun Anda.</p>
                </div>
            </div>

            <form action="{{ route('profile.update') }}" method="POST">
                @csrf
                @method('PATCH')
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1">Nama Lengkap</label>
                        <input type="text" name="name" value="{{ old('name', $user->name) }}" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 transition-colors" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1">Email</label>
                        <input type="email" name="email" value="{{ old('email', $user->email) }}" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 transition-colors" required>
                    </div>



                    <div class="pt-2">
                        <button type="submit" class="bg-emerald-600 hover:bg-emerald-700 text-white px-6 py-2 rounded-lg font-medium transition-colors text-sm">
                            Simpan Perubahan
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Homepage Settings -->
        <div class="bg-white p-6 rounded-xl border border-slate-200 shadow-sm">
            <div class="flex items-center gap-3 mb-6 pb-4 border-b border-slate-100">
                <div class="w-10 h-10 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center">
                    <i class="fa-solid fa-house-laptop text-lg"></i>
                </div>
                <div>
                    <h3 class="font-bold text-slate-800">Atur Homepage</h3>
                    <p class="text-xs text-slate-500">Tentukan tampilan halaman utama domain Anda.</p>
                </div>
            </div>

            <form action="{{ route('profile.homepage') }}" method="POST">
                @csrf
                @method('PATCH')
                
                <div class="space-y-4">
                    <!-- Option 1: Default -->
                    <label class="flex items-start gap-3 p-3 border border-slate-200 rounded-lg cursor-pointer hover:bg-slate-50 transition-colors">
                        <input type="radio" name="homepage_mode" value="default" class="mt-1 w-4 h-4 text-emerald-600 focus:ring-emerald-500 border-gray-300" {{ old('homepage_mode', $user->homepage_mode ?? 'default') === 'default' ? 'checked' : '' }} onchange="toggleHomepageInput()">
                        <div>
                            <span class="block text-sm font-medium text-slate-900">Default Homepage</span>
                            <span class="block text-xs text-slate-500 mt-1">Tampilkan halaman sambutan "Selamat datang di Selinku".</span>
                        </div>
                    </label>

                    <!-- Option 2: Not Found -->
                    <label class="flex items-start gap-3 p-3 border border-slate-200 rounded-lg cursor-pointer hover:bg-slate-50 transition-colors">
                        <input type="radio" name="homepage_mode" value="not_found" class="mt-1 w-4 h-4 text-emerald-600 focus:ring-emerald-500 border-gray-300" {{ old('homepage_mode', $user->homepage_mode) === 'not_found' ? 'checked' : '' }} onchange="toggleHomepageInput()">
                        <div>
                            <span class="block text-sm font-medium text-slate-900">404 Not Found</span>
                            <span class="block text-xs text-slate-500 mt-1">Tampilkan halaman error 404 jika domain diakses langsung.</span>
                        </div>
                    </label>

                    <!-- Option 3: Redirect -->
                    <div class="space-y-3">
                        <label class="flex items-start gap-3 p-3 border border-slate-200 rounded-lg cursor-pointer hover:bg-slate-50 transition-colors">
                            <input type="radio" name="homepage_mode" value="redirect" class="mt-1 w-4 h-4 text-emerald-600 focus:ring-emerald-500 border-gray-300" {{ old('homepage_mode', $user->homepage_mode) === 'redirect' ? 'checked' : '' }} onchange="toggleHomepageInput()">
                            <div>
                                <span class="block text-sm font-medium text-slate-900">Redirect (Peralihan)</span>
                                <span class="block text-xs text-slate-500 mt-1">Alihkan pengunjung ke URL lain secara otomatis.</span>
                            </div>
                        </label>
                        
                        <div id="redirectUrlInput" class="{{ old('homepage_mode', $user->homepage_mode) === 'redirect' ? '' : 'hidden' }} ml-7">
                            <label class="block text-sm font-medium text-slate-700 mb-1">URL Tujuan</label>
                            <input type="url" name="homepage_redirect_url" value="{{ old('homepage_redirect_url', $user->homepage_redirect_url) }}" placeholder="https://example.com" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 transition-colors">
                            <p class="text-xs text-slate-400 mt-1">Pastikan menggunakan http:// atau https://</p>
                        </div>
                    </div>

                    <div class="pt-2">
                        <button type="submit" class="bg-emerald-600 hover:bg-emerald-700 text-white px-6 py-2 rounded-lg font-medium transition-colors text-sm">
                            Simpan Pengaturan Homepage
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <script>
            function toggleHomepageInput() {
                const isRedirect = document.querySelector('input[name="homepage_mode"][value="redirect"]').checked;
                const inputDiv = document.getElementById('redirectUrlInput');
                if (isRedirect) {
                    inputDiv.classList.remove('hidden');
                } else {
                    inputDiv.classList.add('hidden');
                }
            }
        </script>



    </div>
</div>
@endsection
