<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" type="image/svg+xml" href="<?php echo e(asset('favicon.svg')); ?>">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo $__env->yieldContent('title', 'Dashboard - Selinku'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        ::-webkit-scrollbar {
            width: 8px;
        }
        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }
        ::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 4px;
        }
        ::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }
        .fade-in {
            animation: fadeIn 0.3s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        /* Safe area for bottom nav on iPhone X+ */
        .pb-safe {
            padding-bottom: env(safe-area-inset-bottom);
        }
        /* Tooltip hint for truncated text */
        .cursor-help {
            cursor: help;
            text-decoration: underline;
            text-decoration-style: dotted;
            text-decoration-color: #cbd5e1;
            text-underline-offset: 2px;
        }
        .cursor-help:hover {
            text-decoration-color: #94a3b8;
        }
    </style>
</head>
<body class="bg-slate-50 text-slate-800">

    <div class="flex h-screen overflow-hidden">
        
        <!-- Sidebar (Desktop Only) -->
        <aside class="hidden lg:flex fixed inset-y-0 left-0 z-30 w-64 bg-white border-r border-slate-200 flex-col">
            <!-- Logo -->
            <div class="h-16 flex items-center px-6 border-b border-slate-100">
                <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-2 text-emerald-600 font-bold text-xl">
                    <i class="fa-solid fa-link"></i>
                    <span>Selin<span class="text-slate-800">ku</span></span>
                </a>
            </div>

            <!-- Nav Links -->
            <nav class="flex-1 overflow-y-auto py-4 px-3 space-y-1">
                <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-colors <?php echo e(request()->routeIs('dashboard') ? 'bg-emerald-50 text-emerald-600' : 'text-slate-600 hover:text-emerald-600 hover:bg-slate-50'); ?>">
                    <i class="fa-solid fa-plus-circle w-5"></i>
                    Buat Link Baru
                </a>
                <a href="<?php echo e(route('shortlinks.index')); ?>" class="flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-colors <?php echo e(request()->routeIs('shortlinks.*') ? 'bg-emerald-50 text-emerald-600' : 'text-slate-600 hover:text-emerald-600 hover:bg-slate-50'); ?>">
                    <i class="fa-solid fa-list w-5"></i>
                    Daftar Link
                </a>
                <a href="<?php echo e(route('analytics.index')); ?>" class="flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-colors <?php echo e(request()->routeIs('analytics.*') ? 'bg-emerald-50 text-emerald-600' : 'text-slate-600 hover:text-emerald-600 hover:bg-slate-50'); ?>">
                    <i class="fa-solid fa-chart-line w-5"></i>
                    Statistik
                </a>
                <div class="pt-4 pb-2">
                    <p class="px-3 text-xs font-semibold text-slate-400 uppercase tracking-wider">Pengaturan</p>
                </div>
                <a href="<?php echo e(route('profile.index')); ?>" class="flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-colors <?php echo e(request()->routeIs('profile.*') ? 'bg-emerald-50 text-emerald-600' : 'text-slate-600 hover:text-emerald-600 hover:bg-slate-50'); ?>">
                    <i class="fa-solid fa-user-gear w-5"></i>
                    Profil
                </a>
                <a href="<?php echo e(route('security.index')); ?>" class="flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-colors <?php echo e(request()->routeIs('security.*') ? 'bg-emerald-50 text-emerald-600' : 'text-slate-600 hover:text-emerald-600 hover:bg-slate-50'); ?>">
                    <i class="fa-solid fa-user-shield w-5"></i>
                    Keamanan
                </a>
                <a href="<?php echo e(route('attribution')); ?>" class="flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-colors <?php echo e(request()->routeIs('attribution') ? 'bg-emerald-50 text-emerald-600' : 'text-slate-600 hover:text-emerald-600 hover:bg-slate-50'); ?>">
                    <i class="fa-solid fa-heart w-5"></i>
                    Atribusi
                </a>
            </nav>

            <!-- User Profile (Bottom Sidebar) -->
            <div class="p-4 border-t border-slate-100">
                <div class="flex items-center gap-3">
                    <img src="https://ui-avatars.com/api/?name=<?php echo e(urlencode(Auth::user()->name)); ?>&background=059669&color=fff" alt="Admin" class="w-9 h-9 rounded-full">
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-medium text-slate-900 truncate"><?php echo e(Auth::user()->name); ?></p>
                        <p class="text-xs text-slate-500 truncate"><?php echo e(Auth::user()->email); ?></p>
                    </div>
                </div>
                <div class="mt-4 pt-4 border-t border-slate-50">
                    <form action="<?php echo e(route('logout')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full flex items-center justify-center gap-2 px-4 py-2 text-xs font-medium text-red-600 bg-red-50 hover:bg-red-100 rounded-lg transition-colors">
                            <i class="fa-solid fa-right-from-bracket"></i>
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 flex flex-col lg:ml-64 h-full relative w-full">
            
            <!-- Top Navbar -->
            <header class="h-16 bg-white border-b border-slate-200 flex items-center justify-between px-4 lg:px-8 z-20">
                <!-- Mobile Logo (Left) -->
                <div class="lg:hidden flex items-center gap-2 text-emerald-600 font-bold text-lg">
                    <i class="fa-solid fa-link"></i>
                    <span>Selin<span class="text-slate-800">ku</span></span>
                </div>
                
                <h1 class="hidden lg:block text-lg font-semibold text-slate-800">Dashboard</h1>

                <!-- Right Side Tools -->
                <div class="flex items-center gap-4 ml-auto">
                    <div class="relative hidden sm:block">
                        <form action="<?php echo e(route('shortlinks.index')); ?>" method="GET">
                            <i class="fa-solid fa-search absolute left-3 top-1/2 -translate-y-1/2 text-slate-400 text-sm"></i>
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Cari link..." class="pl-9 pr-4 py-2 bg-slate-100 border-none rounded-full text-sm focus:ring-2 focus:ring-emerald-500 focus:bg-white transition-all w-64 outline-none">
                        </form>
                    </div>
                    <?php
                        $unreadNotifs = auth()->user()->unreadNotifications;
                        $hasUnread = $unreadNotifs->count() > 0;
                    ?>
                    <div class="relative">
                        <button onclick="toggleNotif()" class="relative p-2 text-slate-500 hover:text-emerald-600 transition-colors">
                            <i class="fa-regular fa-bell text-xl"></i>
                            <?php if($hasUnread): ?>
                            <span class="absolute top-1.5 right-1.5 w-2.5 h-2.5 bg-red-500 rounded-full border-2 border-white"></span>
                            <?php endif; ?>
                        </button>

                        <!-- Notification Dropdown -->
                        <div id="notifDropdown" class="hidden absolute right-0 mt-4 w-80 bg-white rounded-xl shadow-[0_4px_20px_rgba(0,0,0,0.08)] border border-slate-100 overflow-hidden z-50 origin-top-right transform transition-all">
                            <div class="p-4 border-b border-slate-50 flex items-center justify-between bg-slate-50/50">
                                <h3 class="font-semibold text-sm text-slate-800">Notifikasi</h3>
                                <?php if($hasUnread): ?>
                                <button type="button" onclick="openClearModal()" class="text-xs text-red-500 hover:text-red-700 font-medium">Hapus Semua</button>
                                <?php endif; ?>
                            </div>
                            
                            <div class="max-h-[300px] overflow-y-auto">
                                <?php $__empty_1 = true; $__currentLoopData = $unreadNotifs->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <a href="<?php echo e($notif->data['link'] ?? '#'); ?>" class="block p-4 hover:bg-slate-50 border-b border-slate-50 last:border-0 transition-colors group">
                                    <div class="flex gap-3">
                                        <div class="w-8 h-8 rounded-full <?php echo e($notif->data['color'] ?? 'bg-slate-100 text-slate-500'); ?> flex items-center justify-center shrink-0">
                                            <i class="fa-solid <?php echo e($notif->data['icon'] ?? 'fa-bell'); ?> text-xs"></i>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-slate-800 group-hover:text-emerald-600 transition-colors"><?php echo e($notif->data['title'] ?? 'Info'); ?></p>
                                            <p class="text-xs text-slate-500 mt-0.5 leading-relaxed"><?php echo e($notif->data['message'] ?? ''); ?></p>
                                            <p class="text-[10px] text-slate-400 mt-1.5"><?php echo e($notif->created_at->diffForHumans()); ?></p>
                                        </div>
                                    </div>
                                </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="p-8 text-center">
                                    <div class="w-12 h-12 bg-slate-50 rounded-full flex items-center justify-center mx-auto mb-3 text-slate-300">
                                        <i class="fa-regular fa-bell-slash text-lg"></i>
                                    </div>
                                    <p class="text-xs text-slate-500">Tidak ada notifikasi baru</p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Scrollable Content with Bottom Padding for Mobile Nav -->
            <div class="flex-1 overflow-y-auto p-4 lg:p-8 pb-24 lg:pb-8">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
    </div>

    <!-- Mobile Bottom Navigation -->
    <div class="fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 lg:hidden z-40 flex items-center justify-around pb-1 pt-1 shadow-[0_-4px_20px_rgba(0,0,0,0.03)] h-16 pb-safe">
        <a href="<?php echo e(route('dashboard')); ?>" class="flex flex-col items-center justify-center w-full h-full space-y-1 <?php echo e(request()->routeIs('dashboard') ? 'text-emerald-600' : 'text-slate-400 hover:text-slate-600'); ?>">
            <i class="fa-solid fa-plus-circle text-xl leading-none"></i>
            <span class="text-[10px] font-medium leading-none">Buat</span>
        </a>
        <a href="<?php echo e(route('shortlinks.index')); ?>" class="flex flex-col items-center justify-center w-full h-full space-y-1 <?php echo e(request()->routeIs('shortlinks.*') ? 'text-emerald-600' : 'text-slate-400 hover:text-slate-600'); ?>">
            <i class="fa-solid fa-list-ul text-lg leading-none"></i>
            <span class="text-[10px] font-medium leading-none">Links</span>
        </a>
        <a href="<?php echo e(route('analytics.index')); ?>" class="flex flex-col items-center justify-center w-full h-full space-y-1 <?php echo e(request()->routeIs('analytics.*') ? 'text-emerald-600' : 'text-slate-400 hover:text-slate-600'); ?>">
            <i class="fa-solid fa-chart-pie text-lg leading-none"></i>
            <span class="text-[10px] font-medium leading-none">Stats</span>
        </a>
        <div class="relative w-full h-full">
            <a href="javascript:void(0)" onclick="toggleMobileAccountMenu(event)" class="flex flex-col items-center justify-center w-full h-full space-y-1 cursor-pointer <?php echo e(request()->routeIs('profile.*') || request()->routeIs('security.*') ? 'text-emerald-600' : 'text-slate-400 hover:text-slate-600'); ?>">
                <div class="relative">
                    <i class="fa-solid fa-user text-lg leading-none"></i>
                    <span class="absolute -top-1 -right-1 w-2 h-2 rounded-full bg-red-500 border border-white <?php echo e(isset($hasUnread) && $hasUnread ? '' : 'hidden'); ?>"></span>
                </div>
                <span class="text-[10px] font-medium leading-none">Akun</span>
            </a>
            <div id="mobileAccountMenu" class="hidden absolute bottom-16 right-2 w-48 bg-white rounded-xl shadow-[0_4px_20px_rgba(0,0,0,0.15)] border border-slate-100 overflow-hidden z-[60] flex flex-col transform origin-bottom-right transition-all animate-fade-in-up">
                <a href="<?php echo e(route('profile.index')); ?>" class="px-4 py-3 text-sm text-slate-700 hover:bg-slate-50 hover:text-emerald-600 border-b border-slate-50 flex items-center gap-3 transition-colors">
                     <i class="fa-regular fa-user text-slate-400 w-4"></i> Profil Saya
                </a>
                <a href="<?php echo e(route('security.index')); ?>" class="px-4 py-3 text-sm text-slate-700 hover:bg-slate-50 hover:text-emerald-600 flex items-center gap-3 transition-colors">
                     <i class="fa-solid fa-lock text-slate-400 w-4"></i> Keamanan
                </a>
                <a href="<?php echo e(route('attribution')); ?>" class="px-4 py-3 text-sm text-slate-700 hover:bg-slate-50 hover:text-emerald-600 flex items-center gap-3 transition-colors">
                     <i class="fa-solid fa-heart text-slate-400 w-4"></i> Atribusi
                </a>
                <form action="<?php echo e(route('logout')); ?>" method="POST" class="border-top border-slate-50">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full text-left px-4 py-3 text-sm text-red-600 hover:bg-red-50 flex items-center gap-3 transition-colors">
                        <i class="fa-solid fa-right-from-bracket text-red-500 w-4"></i> Logout
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Toast Notification -->
    <div id="toast" class="fixed bottom-20 right-5 lg:bottom-5 transform translate-y-20 opacity-0 transition-all duration-300 bg-slate-800 text-white px-6 py-3 rounded-lg shadow-lg flex items-center gap-3 z-50 pointer-events-none">
        <i class="fa-solid fa-circle-check text-green-400"></i>
        <span id="toastMessage">Berhasil!</span>
    </div>

    <!-- Clear Notification Confirmation Modal & Scripts -->
    <!-- (Modal code remains same, included below) -->
    <div id="clearNotifModal" class="fixed inset-0 z-[100] hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true" onclick="closeClearModal()"></div>
            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
            <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg w-full">
                <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <p class="text-sm text-gray-500">Hapus semua notifikasi?</p>
                </div>
                <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <form action="<?php echo e(route('notifications.clear')); ?>" method="POST">
                         <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                         <button type="submit" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 focus:outline-none sm:ml-3 sm:w-auto sm:text-sm">Hapus</button>
                    </form>
                    <button type="button" onclick="closeClearModal()" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">Batal</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Scripts
        function toggleNotif() {
            const dropdown = document.getElementById('notifDropdown');
            dropdown.classList.toggle('hidden');
        }
        function toggleMobileAccountMenu(event) {
            if (event) event.preventDefault();
            const menu = document.getElementById('mobileAccountMenu');
            menu.classList.toggle('hidden');
        }
        function openClearModal() {
            document.getElementById('clearNotifModal').classList.remove('hidden');
            document.getElementById('notifDropdown').classList.add('hidden');
        }
        function closeClearModal() {
            document.getElementById('clearNotifModal').classList.add('hidden');
        }
        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            // Notif Dropdown
            const notifDropdown = document.getElementById('notifDropdown');
            const notifButton = event.target.closest('button[onclick="toggleNotif()"]');
            const insideNotifDropdown = event.target.closest('#notifDropdown');
            
            if (!notifButton && !insideNotifDropdown && notifDropdown && !notifDropdown.classList.contains('hidden')) {
                notifDropdown.classList.add('hidden');
            }

            // Mobile Account Menu
            const mobileMenu = document.getElementById('mobileAccountMenu');
            const mobileBtn = event.target.closest('a[onclick*="toggleMobileAccountMenu"]');
            const insideMobileMenu = event.target.closest('#mobileAccountMenu');
            
            if (!mobileBtn && !insideMobileMenu && mobileMenu && !mobileMenu.classList.contains('hidden')) {
                mobileMenu.classList.add('hidden');
            }
        });

        function showToast(msg) {
            const toast = document.getElementById('toast');
            document.getElementById('toastMessage').textContent = msg;
            toast.classList.remove('translate-y-20', 'opacity-0', 'pointer-events-none');
            setTimeout(() => { 
                toast.classList.add('translate-y-20', 'opacity-0', 'pointer-events-none'); 
            }, 3000);
        }

        function copyLink(text) {
             // ... copy logic ...
             if(navigator.clipboard && navigator.clipboard.writeText) {
                 navigator.clipboard.writeText(text).then(() => {
                     showToast('Link berhasil disalin!');
                 }).catch(() => {
                     fallbackCopy(text);
                 });
             } else {
                 fallbackCopy(text);
             }
        }
        function fallbackCopy(text){
            const textArea = document.createElement("textarea");
            textArea.value = text;
            document.body.appendChild(textArea);
            textArea.select();
            try { document.execCommand('copy'); showToast('Link berhasil disalin!'); } 
            catch (err) { showToast('Gagal menyalin link'); }
            document.body.removeChild(textArea);
        }
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH D:\LARAVELKU\SHORLINTKU\resources\views/layouts/dashboard.blade.php ENDPATH**/ ?>